#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../scorpion.h"

static GrVertex Fond1 = {0.f,0.f,1,  255,128,128,   0,128.f,1.f/1,{0,0, 1.f/1}};
static GrVertex Fond2 = {640.f,0,1,   128,255,128,   0,128.f,1.f/1,{256.f/1,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,1,   64,64,192,   0,128.f,1.f/1,{256.f/1,256.f/1,1.f/1}};
static GrVertex Fond4 = {0,480.,1,   64,64,192,   0,128.f,1.f/1,{0,256.f/1,1.f/1}};

static FbVertex pVertexIn[] = {
	{-100.f,0.f,-100.f, 255.f,255.f,255.f, 0,0,0, {0,0}},
	{100.f,0.f,-100.f, 0.f, 255.f, 0.f, 0,0,0, {256,0}},
	{100.f,0.f,100.f, 0.f, 0.f, 255.f, 0,0,0, {256,256}},
	{-100.f,0.f,100.f, 0.f, 0.f, 255.f, 0,0,0, {0,256}},
};
static GrVertex pVertexOut[sizeof(pVertexIn)/sizeof(FbVertex)];

Face pFace[] = {
	{0,1,2},
	{2,3,0}
};

static Obj3d Sol = {
	pVertexIn,
	pVertexOut,
	sizeof(pVertexIn)/sizeof(FbVertex),
	pFace,
	sizeof(pFace)/sizeof(Face)
};

static WORD Randtext[65536];
static JpegTexture TextTex;

static Obj3d Niels, Mal;
static float Matrix[16], Matrix2[16];
static float Gouraud[16], Gouraud2[16];


void LInit_Credits()
{
	int Cpt1, Cpt2, Cpt3, Cpt4;
	int letter;

	srand((unsigned)time(NULL));

	for(Cpt1=0;Cpt1<32;Cpt1++){ // line of character
		for(Cpt2=0;Cpt2<32;Cpt2++){ // column of character
			letter = (rand()%26)+'A';
			for(Cpt3=0;Cpt3<8;Cpt3++){
				for(Cpt4=0;Cpt4<8;Cpt4++){
					Randtext[(Cpt1*8*256+Cpt3*256)+Cpt2*8+Cpt4] = 
						g_PicFont2[letter*8+Cpt3*1024+Cpt4];
				}
			}
		}
	}

	PrepareTextureFromArray(g_PicRonds, 256, 256, &g_TextureRonds);
	PrepareTextureFromArray(Randtext, 256, 256, &TextTex);

	LoadObject(&Niels, nielsvtx, nielsface);
	LoadObject(&Mal, malcolmzvtx, malcolmzface);
	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 2048);
	ApplyMatrix(&Niels, Matrix2);
	ApplyMatrix(&Mal, Matrix2);
	ComputeGouraud(&Niels);
	ComputeGouraud(&Mal);
}


void QInit_Credits()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grAlphaCombine(GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_FACTOR_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);

	grAlphaTestFunction(GR_CMP_ALWAYS);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grCullMode(GR_CULL_DISABLE);

	grFogMode(GR_FOG_WITH_TABLE);
	grFogColorValue(0);
	grFogTable(g_FogHomer);

	DownloadTexture(&g_TextureRonds);
	DownloadTexture(&TextTex);
}

void Effect_Credits()
{
	DWORD Cpt1;
	float fTmp;
	float x, y;
	static DWORD dwLast = 0;
	float transX, transY;

	DWORD dwTmp;

	grColorCombine(GR_COMBINE_FUNCTION_LOCAL,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grDepthBufferFunction(GR_CMP_LESS);
	BeIdentityMatrix(Gouraud);
	BeIdentityMatrix(Matrix);
	ScaleMatrix(Matrix, 1, 1, 7.5f + 7.f*SinTable[((g_demostate.TickInEffect)*32)&8191]);
	RotateZMatrix(Matrix2, Matrix, CosTable[(g_demostate.TickInEffect*8)&8191]*1024);

	if (g_demostate.midas_status.position==37)
	{
		TranslateMatrix(Matrix2, 0, 0, 300);
		DrawWithMatrix(&Niels, Matrix2, TRUE, Gouraud, 0);
	}
	else
	{
		TranslateMatrix(Matrix2, 0, 0, 350);
		DrawWithMatrix(&Mal, Matrix2, TRUE, Gouraud, 0);
	}

	SelectTexture(g_TextureRonds);
	grDepthBufferFunction(GR_CMP_ALWAYS);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
			GR_COMBINE_FACTOR_ONE,
			GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grFogMode(GR_FOG_WITH_TABLE);
	BeIdentityMatrix(Matrix);
	RotateYMatrix(Matrix2, Matrix, g_demostate.TickInEffect*2);
	RotateXMatrix(Matrix, Matrix2, 512);
	TranslateMatrix(Matrix, 0, 40, 150);
	DrawWithMatrix(&Sol, Matrix, 0, 0, 0);

	BeIdentityMatrix(Matrix);
	fTmp = 1.f + CosTable[(g_demostate.TickInEffect*8)&8191]/4.f;
	ScaleMatrix(Matrix, fTmp, fTmp, fTmp);
	RotateYMatrix(Matrix2, Matrix, g_demostate.TickInEffect*2);
	RotateXMatrix(Matrix, Matrix2, 512);
	TranslateMatrix(Matrix, 0, 40, 150);
	DrawWithMatrix(&Sol, Matrix, 0, 0, 0);

	BeIdentityMatrix(Matrix);
	RotateYMatrix(Matrix2, Matrix, g_demostate.TickInEffect*2);
	RotateXMatrix(Matrix, Matrix2, -512);
	TranslateMatrix(Matrix, 0, -40, 150);
	DrawWithMatrix(&Sol, Matrix, 0, 0, 0);

	BeIdentityMatrix(Matrix);
	ScaleMatrix(Matrix, fTmp, fTmp, fTmp);
	RotateYMatrix(Matrix2, Matrix, g_demostate.TickInEffect*2);
	RotateXMatrix(Matrix, Matrix2, -512);
	TranslateMatrix(Matrix, 0, -40, 150);
	DrawWithMatrix(&Sol, Matrix, 0, 0, 0);

	SelectTexture(TextTex);
	grFogMode(GR_FOG_DISABLE);
	if (dwLast+10<g_demostate.TickInEffect)
	{
		dwLast = g_demostate.TickInEffect;
		x = (rand()&31)*8-128;
		y = (rand()&31)*8-128;
	}
	transX = CosTable[g_demostate.TickInEffect&8191]*64.f;
	transY = SinTable[g_demostate.TickInEffect&8191]*64.f;
	Fond1.tmuvtx[0].sow = x+transX;
	Fond2.tmuvtx[0].sow = x+256+transX;
	Fond3.tmuvtx[0].sow = x+256+transX;
	Fond4.tmuvtx[0].sow = x+transX;
	Fond1.tmuvtx[0].tow = y+transY;
	Fond2.tmuvtx[0].tow = y+transY;
	Fond3.tmuvtx[0].tow = y+256+transY;
	Fond4.tmuvtx[0].tow = y+256+transY;
	if (g_demostate.TickInEffect<512){
		dwTmp = g_demostate.TickInEffect/2;
		dwTmp = CLIP_DW(dwTmp);
		dwTmp = dwTmp|(dwTmp<<8)|(dwTmp<<16);
		grConstantColorValue(dwTmp);
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL,
						GR_COMBINE_FACTOR_ONE,
						GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	}
	else{
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
				GR_COMBINE_FACTOR_ONE,
				GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	}
	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);
}

void ByeBye_Credits()
{
	FreeTexture(&TextTex);
	FreeTexture(&g_TextureRonds);
}
